 ; Ŀ
 ;   Tswap - text position switcher                                        
 ;   Copyright 1995, 2008 by Rocket Software Ltd.                          
 ;   You want a routine to do what?  Our employees can't do that.          
 ; 

 ; Ŀ
 ;   Subroutine CCirc - returns the centre point of a text entity.         
 ;   Takes one argument - Enam, the text entity name.                      
 ;   Currently not called.                                                 
 ; 
 (DEFUN CCIRC (enam / entt bb rota cc dd bheigt bwidth llangg lldist
                                                                ll ul lr ur pa)
  (setq entt (entget enam))
  (if (setq bb (textbox entt))
      (progn
          (setq rota (cdr (assoc 50 entt)))
          (setq cc (car bb))                    ; ll offset from 10 of text
          (setq dd (cadr bb))                   ; ur offset from 10 of text
          (setq bheigt (- (cadr dd) (cadr cc)))
          (setq bwidth (- (car dd) (car cc)))
          (setq llangg (angle (list 0 0) cc))
          (setq lldist (distance (list 0 0) cc))
          (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
          (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
          (setq lr (polar ll rota bwidth))
          (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
          (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0))))))
 ; Ŀ
 ;   CCirc end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Tswap - do it.                                                        
 ; 
 (DEFUN C:TSWAP (/ snapp enam entt renam ss1 ss2 p1 p2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (setvar "snapmode" snapp)
   (if renam (redraw renam 4))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Peel end.                                                             
 ; 
  (setq t1 (entsel "First text entity: "))
  (setq entt (entget (setq enam (car t1))))
  (setq typ (cdr (assoc 0 entt)))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (princ (cdr (assoc 1 entt)))
           (redraw (setq renam enam) 3)
           (setq p1 (spit entt))
           (setq t2 (entsel "\nSecond text entity: "))
           (setq p2 (spit (entget (car t2))))
           (command "move" t1 "" p1 p2)
           (command "move" t2 "" p2 p1)))
  (*error* nil)
 (princ))